package lib.xml;

import java.io.FileNotFoundException;
import java.io.IOException;

public class XMLDocRoot {

	/** ルートのXMLオブジェクト */
    public XMLParser rootNode = null;

    /**
     * デフォルトコンストラクタ
     */
    public XMLDocRoot() {}

    /**
     * ルートの名称を設定するコンストラクタ
     * @param rootName
     */
    public XMLDocRoot(String rootName) {
    	rootNode = new XMLParser();
    	rootNode.setNodeName(rootName);
    }

    /**
     * デフォルトコンストラクタを使用した場合、
     * 後でルートを設定する
     * @param root
     */
    public void setRoot(XMLParser root) {
    	rootNode = root;
    }

    /**
     * ルート取得
     * @return
     */
    public XMLParser getRoot() {
    	return rootNode;
    }

    /**
     * 指定したファイルにXMLファイルとして出力
     * @param path
     * @throws FileNotFoundException
     * @throws IOException
     */
    public void FileWrite(String path) throws FileNotFoundException, IOException {
        // 基本タグを作成
        XMLParser documentObj = new XMLParser("document");

        // 先頭に改行を挿入
        documentObj.appendChild(XMLParser.createTextNode("\r\n"));
        documentObj.appendChild(rootNode);
        XMLParser writeXml = new XMLParser();
        writeXml.appendChild(documentObj);
        // ファイル書き込み
        writeXml.xmlFileWrite(path);
    }
}
